@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{app()->getLocale()=='en'?asset('website/css/custom/blog-details.css'):asset('website/css/custom/blog-details-rtl.css')}}">

@endsection
@section('page-title')
    {{__('website.reviews')}}
@endsection

@section('banner')

    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1> {{__('website.reviews')}} </h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item"><a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}">{{$shop->name}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.reviews')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('content')
    <section class="blog-details-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">


                    <div class="common-card no-padding" id="review">
                        <div class="card-header">
                            <h5 class="card-title">{{__('website.reviews')}} ({{$shop->reviews_count}})</h5>
                        </div>

                        <div class="height-100 ">
                            <div class="card p-3 rating-card mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="ratings">
                                        @for($i=0; $i<(int)$shop->average_rate; $i++)
                                            <i class="fa fa-star rating-color"></i>
                                        @endfor
                                        @for($i=0; $i<(5-$shop->average_rate); $i++)
                                                <i class="fa fa-star"></i>
                                            @endfor

                                        <span class="total-number-review">({{$shop->rates_count}})</span>
                                    </div>
                                    <h5 class="review-count">{{$shop->reviews_count}} {{__('website.reviews')}}</h5>
                                </div>

                            </div>
                        </div>
                        <div class="ad-details-review">
                            @if(count($reviews))
                            <ul class="review-list">
                            @foreach($reviews as $review)
                                <li class="review-item">
                                    <div class="review-user">
                                        <div class="review-head">
                                            <div class="review-profile">
                                                <a href="#" class="review-avatar"><img src="{{$review->user->image()??'/website/images/avatar/profile-default.png'}}" alt="{{$review->user->name??__('website.image')}}"></a>
                                                <div class="review-meta">
                                                    <h6><a href="#"> {{__('website.moon-user')}}</a><span>{{$review->created_at}}</span></h6>
                                                    <ul>
                                                        @for($i=0; $i<$review->rate; $i++)
                                                            <li><i class="fas fa-star active"></i></li>
                                                        @endfor
                                                        @for($i=0; $i<(5-$review->rate); $i++)
                                                                <li><i class="fas fa-star "></i></li>
                                                        @endfor


                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <p class="review-desc">{{$review->review}}</p>
                                    </div>
                                </li>
                                @endforeach
                            </ul>
                            @endif
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="footer-pagection">
                                            <p class="page-info">{{__('website.Showing')}} {{$reviews->total()}} {{__('website.of')}} {{$reviews->perPage()}} {{__('website.results')}}</p>

                                            {{$reviews->links()}}

                                        </div>

                                    </div>
                                </div>
                                @if(auth()->user())
                                <div class="blog-details-form">
                                    <div class="form-title">
                                        <h3>{{__('website.leave-your-comment')}}</h3>
                                    </div>
                                    <form class="review-form" action="{{route('website.add-comment')}}" method="POST">
                                        @csrf
                                        <input type="hidden" name="store_id" value="{{$shop->id}}">
                                        <div class="star-rating">
                                            <input type="checkbox" value="5" name="rate" id="star-1">
                                            <label for="star-1"></label>
                                            <input type="checkbox" value="4" name="rate" id="star-2">
                                            <label for="star-2"></label>
                                            <input type="checkbox" value="3" name="rate" id="star-3">
                                            <label for="star-3"></label>
                                            <input type="checkbox"  value="2" name="rate" id="star-4">
                                            <label for="star-4"></label>
                                            <input type="checkbox" value="1" name="rate" id="star-5">
                                            <label for="star-5"></label>
                                        </div>

                                        <div class="form-group">
                                            <textarea name="review" class="form-control" placeholder="{{__('website.review')}}"></textarea>
                                        </div>
                                        <button type="submit" class="btn btn-inline review-submit">
                                            <span>{{__('website.write-comment')}}</span></button>
                                    </form>
                                </div>
                                    @endif

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
