@extends('Website.layouts.app',['title'=>__('website.moon').' : '.$shop->city->name.' : '.$shop->name,'description'=>substr($shop->description,1,160)])
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/my-ads.css')}}">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{asset('website/css/custom/style-social.css')}}">
    <link rel="stylesheet" href="{{app()->getLocale()=='en'?asset('website/css/custom/ad-details.css'):asset('website/css/custom/ad-details-rtl.css')}}">

@endsection
@section('meta-deep-link')
    <link rel="icon" href="{{$shop->image()}}" type="image/x-icon">
    <link rel="shortcut icon" href="{{$shop->image()}}" type="image/x-icon">

    <meta property="og:title" content="{{$shop->title}}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{Request::fullUrl()}}">
    <meta property="og:site_name" content="{{Request::url()}}">
    <meta property="og:description" content="{{$shop->description}}">
    <meta property="og:image"  itemprop="image" content="{{$shop->image()}}">
    <meta property="og:image:secure_url"  itemprop="image" content="{{$shop->image()}}">
    <meta property="og:image:width" content="400" />
    <meta property="og:image:height" content="300" />
    <meta property="og:image:type" content="image/webp" />
    <meta property="og:image:alt" content="{{$shop->title}}">

    <meta property="og:updated_time" content="1440432930" />

    <meta property="twitter:title" content="{{$shop->title}}">
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:description" content="{{$shop->description}}">
    <meta property="twitter:site" content="@moon">
    <meta property="twitter:creator" content="@moon">
    <meta property="twitter:image" content="{{$shop->image()}}">
    <meta property="twitter:image:alt" content="{{$shop->title}}">
@endsection

@section('page-title')
    {{$shop->name}}
@endsection

@section('banner')

    <section class="single-banner single-banner2 dashboard-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{$shop->name}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">{{$shop->name}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('content')
    <section class="dash-header-part">
        <div class="container">
            <div class="dash-header-card">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="dash-header-left mb-10">
                            <div class="dash-avatar ad-details-author shop-img">
                                <a class="author-img active" href=""><img src="{{$shop->image()}}"
                                                                          alt="{{$shop->name}}"></a></div>
                            <div class="dash-intro">
                                <h4><a>{{$shop->name}}</a>
                                    <span class="nickname">( {{$shop->nickname}} ) </span>
                                </h4>
                                <div>
                                    <span class="nickname">{{__('website.joined-from')}} {{$shop->created_at}} </span>
                                </div>

                                <label class="" for="chcek5">
                                    <span class="product-widget-star">
                                        @for($i=0; $i<$shop->average_rate;$i++)
                                            <i class="fas fa-star"></i>
                                        @endfor
                                        @if($shop->average_rate<5)
                                            @for($i=0; $i<(5-$shop->average_rate);$i++)
                                                <i class="far fa-star"></i>

                                            @endfor
                                        @endif


                                    </span>
                                    <span class="shop-reviews">
                                        <a href="{{route('website.reviews',$shop->id)}}">{{$shop->average_rate}} {{__('website.review')}}</a>
                                    </span></label>

                                <h5><span><i class="fas fa-circle @if($shop->is_open=='open-now') green @else red @endif"></i> {{__('website.'.$shop->is_open)}} </span>
                                </h5>
                                <ul class="dash-meta">
                                    <li><i class="fas fa-phone-alt"></i><span>
                                            <a class="gray" href="tel:{{$shop->phone}}">{{$shop->phone}}</a></span></li>
                                    <li class="gray"><i class="fas fa-envelope"></i><span>
                                            <a class="gray" href="mailto:{{$shop->email}}">{{$shop->email}}</a></span>
                                    </li>
                                    <li class="gray"><i
                                            class="fas fa-map-marker-alt"></i><span>{{$shop->address}}</span></li>
                                    <li class="gray"><i class="fas fa-globe"></i>
                                        <span>
                                            <a class="gray"
                                               href="{{$shop->website}}">{{$shop->website?$shop->website:__('website.No Website Provided')}}</a></span>
                                    </li>
                                </ul>
                            </div>

                        </div>

                    </div>


                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-12">
                            <div class="ad-details-action ad-details-action2 pb-20  pt-20">
                                @if(auth()->user())
                                    <button type="button" data-toggle="modal" data-target="#profile-share" class="share-btn">
                                        <i
                                            class="fas fa-share-alt"></i>{{__('website.share')}}
                                    </button>
                                    <button class="report-button" type="button" data-toggle="modal"
                                            data-target="#report"><i
                                            class="fas fa-exclamation-triangle"></i>{{__('website.report')}}</button>
                                    <button class="block-button" type="button" data-toggle="modal" data-target="#block">
                                        <i
                                            class="fas fa-ban"></i>
                                        {{__('website.block')}}
                                    </button>
                                    <button class="follow-button wish @if($shop->is_follow==1)  active @endif "
                                            onclick="follow({{$shop->id}})"
                                            type="button" id="follow-{{$shop->id}}"><i
                                            class="fas fa-fas fa-users"></i>{{__('website.follow')}}</button>
                                @else
                                    <button type="button" data-toggle="modal" data-target="#profile-share"
                                            class="share-btn"><i
                                            class="fas fa-share-alt"></i>{{__('website.share')}}
                                    </button>

                                    <button class="report-button" onclick="window.location='{{route('website.login')}}'"
                                            type="button"><i
                                            class="fas fa-exclamation-triangle"></i>{{__('website.report')}}</button>
                                    <button class="block-button" type="button"
                                            onclick="window.location='{{route('website.login')}}'"><i
                                            class="fas fa-ban"></i>
                                        {{__('website.block')}}
                                    </button>
                                    <button class="follow-button wish "
                                            onclick="window.location='{{route('website.login')}}'" type="button"><i
                                            class="fas fa-fas fa-users"></i>{{__('website.follow')}}</button>

                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row ">
                    <div class="col-lg-12">
                        <div class="col-lg-12">
                            <div class="dash-header-right mb-4 mt-1">
                                <div class="dash-focus dash-list">
                                    <h2>{{$shop->advertisements_count}}</h2>
                                    <p>{{__('website.total-ads')}}</p>
                                </div>
                                <div class="dash-focus dash-book">
                                    <a href="{{route('website.followers',$shop->id)}}">
                                        <h2 id="followers-count">{{$shop->followers_count}}</h2>
                                        <p>{{__('website.total-followers')}}</p>
                                    </a>
                                </div>

                                <div class="dash-focus dash-rev">
                                    <a href="{{route('website.reviews',$shop->id)}}">
                                        <h2>{{$shop->reviews_count}}</h2>
                                        <p>{{__('website.total-reviews')}}</p>
                                    </a>
                                </div>
                                <div class="dash-focus dash-rev dash-rev2">
                                    <a href="{{route('website.viewers',$shop->id)}}">
                                        <h2>{{$shop->views_count}}</h2>
                                        <p>{{__('website.total-views')}}</p>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <div class="dash-header-card mt-4 mb-2">

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card-header mt-10">
                            <h5 class="card-title">{{$shop->name}}</h5>
                        </div>
                        <p class="ad-details-desc">{{$shop->description}}</p>


                    </div>
                </div>
                @if(isset($shop->social_media_links)&&count($shop->social_media_links)>0)
                    <div class="modal-share mt-3">
                        @foreach($shop->social_media_links as $social)
                            <a href="{{$social->link}}">
                                <i class="{{$social->type=='youtube'?'youtube-social':$social->type}} fab fa-{{$social->type}}"></i>
                                <span>{{$social->type}}</span>
                            </a>
                        @endforeach


                    </div>
                @endif
            </div>

        </div>
    </section>

    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="dash-menu-list">
                    <ul class="tabs">
                        <li class="tab-link current active" data-tab="tab-1"> {{__('website.advertisements')}} </li>
                        <li class="tab-link " data-tab="tab-2">{{__('website.gallery')}}</li>

                    </ul>
                </div>
            </div>
        </div>
    </div>
    <section class="inner-section ad-list-part mt-5 tab-content current" id="tab-1">

        <div class="container">

            <div class="row content-reverse">
                <div class="col-lg-4 col-xl-3 hidden-small-2">
                    <div class="row sticky mx-h">
                        <form action="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}"
                              method="POST">
                            @csrf
                            <div class="col-md-6 col-lg-12">
                                <div class="product-widget">
                                    <h6 class="product-widget-title">{{__('website.filter-by-price')}}</h6>
                                    <div class="product-widget-form">
                                        <div class="product-widget-group">
                                            <input type="number" name="min_price" min="{{$minPrice}}"
                                                   placeholder="min - {{$minPrice}}">
                                            <input type="number" name="max_price" max="{{$maxPrice}}"
                                                   placeholder="max - {{$maxPrice}}">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-md-6 col-lg-12">
                                <div class="product-widget">
                                    <h6 class="product-widget-title">{{__('website.filter-by-type')}}</h6>
                                    <div class="product-widget-form">
                                        <ul class="product-widget-list">
                                            <li class="product-widget-item">
                                                <div class="product-widget-checkbox"><input type="checkbox"
                                                                                            name="advertisement_type"
                                                                                            value="premium" id="chcek2">
                                                </div>
                                                <label class="product-widget-label" for="chcek2"><span
                                                        class="product-widget-type rent">{{__('website.premium')}}</span><span
                                                        class="product-widget-number">({{$premiumAds}})</span></label>
                                            </li>

                                            <li class="product-widget-item">
                                                <div class="product-widget-checkbox"><input type="checkbox"
                                                                                            name="advertisement_type"
                                                                                            value="regular" id="chcek1">
                                                </div>
                                                <label class="product-widget-label" for="chcek1"><span
                                                        class="product-widget-type sale">{{__('website.regular')}}</span><span
                                                        class="product-widget-number">({{$nonPremiumAds}})</span></label>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            @if(count($cities)>0)
                                <div class="col-md-6 col-lg-12">
                                    <div class="product-widget">
                                        <h6 class="product-widget-title">{{__('website.filter-by-cities')}}</h6>
                                        <div class="product-widget-form">
                                            <ul class="product-widget-list product-widget-scroll">
                                                @foreach($cities as $city)
                                                    <li class="product-widget-item">
                                                        <div class="product-widget-checkbox"><input type="checkbox"
                                                                                                    name="city_id[]"
                                                                                                    value="{{$city->id}}"
                                                                                                    id="chcek{{$city->id}}">
                                                        </div>
                                                        <label class="product-widget-label" for="chcek{{$city->id}}"><span
                                                                class="product-widget-text">{{$city->name}}</span><span
                                                                class="product-widget-number">({{$city->advertisements_count}})</span></label>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            @if(count($categories)>0)

                                <div class="col-md-6 col-lg-12">
                                    <div class="product-widget">
                                        <h6 class="product-widget-title">{{__('website.filter-by-categories')}}</h6>
                                        <div class="product-widget-form">
                                            <ul class="product-widget-list product-widget-scroll">
                                                @foreach($categories as $category)
                                                    <li class="product-widget-item">
                                                        <div class="product-widget-checkbox"><input type="checkbox"
                                                                                                    name="sub_category_id[]"
                                                                                                    value="{{$category->id}}"
                                                                                                    id="chcek{{$category->id}}">
                                                        </div>
                                                        <label class="product-widget-label" for="chcek{{$category->id}}"><span
                                                                class="product-widget-text">{{$category->name}}</span><span
                                                                class="product-widget-number">({{$category->category_advertisements_count}})</span></label>
                                                    </li>
                                                @endforeach

                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            @if(count($rates)>0)

                                <div class="col-md-6 col-lg-12">
                                    <div class="product-widget">
                                        <h6 class="product-widget-title">{{__('website.filter-by-rating')}}</h6>
                                        <div class="product-widget-form">
                                            <ul class="product-widget-list">
                                                @foreach($rates as $rate=>$advertisementsRate)
                                                    <li class="product-widget-item">
                                                        <div class="product-widget-checkbox">
                                                            <input type="checkbox" id="chcek{{$rate}}" name="rates[]"
                                                                   value="{{$rate}}">
                                                        </div>
                                                        <label class="product-widget-label" for="chcek{{$rate}}">
                                                <span class="product-widget-star">
                                                    @for($i=0; $i<$rate; $i++)
                                                        <i class="fas fa-star"></i>
                                                    @endfor
                                                    @for($i=0; $i<(5-$rate); $i++)
                                                        <i class="far fa-star"></i>
                                                    @endfor
                                                </span>
                                                            <span
                                                                class="product-widget-number">({{count($advertisementsRate)}})</span></label>
                                                    </li>
                                                @endforeach
                                            </ul>

                                        </div>
                                    </div>
                                </div>
                            @endif

                            @if(count($properties))
                                @foreach($properties as $property)

                                    <div class="col-md-6 col-lg-12">
                                        <div class="product-widget">
                                            <h6 class="product-widget-title">{{$property->name}}</h6>
                                            <div class="product-widget-form">
                                                <ul class="product-widget-list product-widget-scroll">
                                                    @foreach($property->children as $child )
                                                        <li class="product-widget-item">
                                                            <div class="product-widget-checkbox"><input type="checkbox"
                                                                                                        name="properties[]"
                                                                                                        value="{{$child->id}}"
                                                                                                        id="chcek{{$child->id}}">
                                                            </div>
                                                            <label class="product-widget-label" for="chcek{{$child->id}}"><span
                                                                    class="product-widget-text">{{$child->name}}</span><span
                                                                    class="product-widget-number">({{$child->advertisements_count}})</span></label>
                                                        </li>
                                                    @endforeach

                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif

{{--                            <div class="col-md-6 col-lg-12">--}}
{{--                                <div class="product-widget">--}}
{{--                                    <div class="product-widget-form" style="width: 100%;">--}}
{{--                                        <button type="submit" class="btn btn-inline button-sticky">--}}
{{--                                            <i class="fas fa-search"></i>--}}
{{--                                            <span>{{__('website.search')}}</span></button>--}}

{{--                                    </div>--}}
{{--                                </div>--}}
{{--                            </div>--}}
                        </form>

                    </div>
                </div>
                <div class="col-lg-8 col-xl-9">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="header-filter">
                                <div class="filter-show"><label class="filter-label">Show :</label><select
                                        class="custom-select filter-select">
                                        <option value="1">12</option>
                                        <option value="2">24</option>
                                        <option value="3">36</option>
                                    </select></div>
                                <button type="button" class="header-widget sidebar-btn2 d-xl-hidden d-md-none"><i
                                        class="fas fa-filter"></i></button>
                                <div class="filter-short"><label class="filter-label">Sort By :</label><select
                                        class="custom-select filter-select">
                                        <option selected>default</option>
                                        <option value="3">trending</option>
                                        <option value="1">featured</option>
                                        <option value="2">recommend</option>
                                    </select></div>
                                <div class="filter-action"><a href="ad-list-column3.html" title="Three Column"
                                                              class="active"><i class="fas fa-th"></i></a><a
                                        href="ad-list-column2.html"
                                        title="Two Column"><i class="fas fa-th-large"></i></a><a
                                        href="ad-list-column1.html" title="One Column"><i
                                            class="fas fa-th-list"></i></a></div>
                            </div>
                        </div>
                    </div>
                    @if(count($premiumAdsSlider)>0)

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="ad-feature-slider slider-arrow">
                                    @foreach($premiumAdsSlider as $premiumAd)
                                        <div class="feature-card">
                                            <a href="#" class="feature-img">
                                                <img
                                                    src="{{$premiumAd->image()}}"
                                                    alt="feature"></a>
                                            <div class="cross-inline-badge feature-badge">
                                                <span>@if($premiumAd->is_negotiable==0) {{__('website.negotiable')}} @else {{__('website.not-negotiable')}} @endif</span><i
                                                    class="fas fa-book-open"></i></div>
                                            <button type="button"
                                                    class="feature-wish"><i class="fas fa-heart"></i></button>
                                            <div class="feature-content">
                                                <ol class="breadcrumb feature-category">
                                                    <li><span class="flat-badge rent">rent</span></li>
                                                    <li class="breadcrumb-item"><a href="{{route('website.all-advertisements',['category'=>$premiumAd->subCategory->category->slug,'type'=>'View'])}}">{{$premiumAd->subCategory->category->name}}</a></li>
                                                    <li class="breadcrumb-item active" aria-current="page"><a href="{{route('website.all-advertisements',['category'=>$premiumAd->subCategory->slug,'type'=>'View'])}}">{{$premiumAd->subCategory->name}}</a></li>
                                                </ol>
                                                <h3 class="feature-title"><a
                                                        href="{{route('website.advertisement-details',['id'=>$premiumAd->id,'slug'=>$premiumAd->slug])}}">{{$premiumAd->title}}</a>
                                                </h3>
                                                <div class="feature-meta"><span
                                                        class="feature-price">{{$premiumAd->price}} {{$premiumAd->city->country->currency}}</span><span
                                                        class="feature-time"><i class="fas fa-clock"></i>{{$premiumAd->created_at}}</span>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                    @if(count($advertisements)>0)
                        <div class="row">

                            @foreach($advertisements as $advertisement)

                                <div class="col-sm-6 col-md-6 col-lg-6 col-xl-4">
                                    <div class="product-card">
                                        <div class="product-media">
                                            <a href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug,'type'=>'View'])}}" tabindex="0">
                                                <div class="product-img"><img src="{{$advertisement->image()}}"
                                                                              alt="{{$advertisement->title}}"></div>
                                            </a>
                                            @if($advertisement->premium==0)
                                                <div class="cross-vertical-badge product-badge"><i
                                                        class="fas fa-clipboard-check"></i>
                                                    <span>{{__('website.regular')}}</span>
                                                </div>
                                            @else
                                                <div class="cross-vertical-badge product-badge">
                                                    <i class="fas fa-bolt"></i>
                                                    <span>{{__('website.premium')}}</span>
                                                </div>
                                            @endif
                                            @if($advertisement->is_negotiable==1)
                                                <div class="product-type"><span
                                                        class="flat-badge rent">{{__('website.negotiable')}}</span>
                                                </div>
                                            @else
                                                <div class="product-type"><span
                                                        class="flat-badge sale">{{__('website.not-negotiable')}}</span>
                                                </div>

                                            @endif
                                            <ul class="product-action">
                                                <li class="view"><i
                                                        class="fas fa-eye"></i><span>{{$advertisement->views_count}}</span>
                                                </li>
                                                <li class="click"><i
                                                        class="fas fa-heart"></i><span>{{$advertisement->favorite_count}}</span>
                                                </li>
                                                <li class="rating"><i class="fas fa-star"></i><span>{{$advertisement->rate_count}}/5</span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="product-content">
                                            <ol class="breadcrumb product-category">
                                                <li><i class="fas fa-tags"></i></li>
                                                <li class="breadcrumb-item"><a href="{{route('website.all-advertisements',['category'=>$advertisement->subCategory->category->slug,'type'=>'View'])}}">{{$advertisement->subCategory->category->name}}</a></li>
                                                <li class="breadcrumb-item active" aria-current="page"><a href="{{route('website.all-advertisements',['category'=>$advertisement->subCategory->slug,'type'=>'View'])}}">{{$advertisement->subCategory->name}}</a></li>
                                            </ol>
                                            <h5 class="product-title"><a href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug,'type'=>'View'])}}">
                                                    {{$advertisement->title}}
                                                </a></h5>
                                            <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>
                                                    {{$advertisement->city->country->name}},
                                            {{$advertisement->city->name}}</span><span><i class="fas fa-clock"></i>{{$advertisement->created_at}}</span>
                                            </div>
                                            <div class="product-info">
                                                <h5 class="product-price">{{$advertisement->price}} {{$advertisement->city->country->currency}}</h5>
                                                <div class="product-btn"><a href="tel:{{$advertisement->phone}}"
                                                                            title="call"
                                                                            class="fas fa-phone-alt"></a>
{{--                                                    <a href="{{$advertisement->store_id}}" title="chat"--}}
{{--                                                       class="fas fa-comments"></a>--}}
                                                    <button type="button" title="whatsapp"
                                                            onclick="location.href='https://api.whatsapp.com/send?phone={{$advertisement->phone}}'"
                                                            class="fab fa-whatsapp no-top" tabindex="0"></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            @endforeach
                        </div>

                    @endif
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="footer-pagection">
                                <p class="page-info">{{__('website.Showing-20-of')}} {{$advertisements->total()}} {{__('website.results')}}</p>
                                {{$advertisements->links()}}
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
    <section class="inner-section ad-list-part mt-5 tab-content " id="tab-2">
        <div class="container">
            <div class="row content-reverse">
                <div class="col-md-12">
                    @if(count($shop->explores) > 0)
                        <div class="container-fluid gallery">

                            @foreach($shop->explores as $explore)
                                <div class="product-card product-card-shop big">
                                    <div class="product-media product-media-gallery">

                                        <a href="{{route('website.explore-details',$explore->id)}}" tabindex="0">
                                            <div class="product-img custom-product-img"><img src="{{$explore->file()}}"
                                                                          alt="{{$shop->name}}"></div>
                                        </a>

                                        <ul class="product-action product-action-gallery">
                                            <li class="view"><i class="fas fa-comments"></i>
                                                <span>{{$explore->comments_count}}</span></li>
                                            <li class="click">
                                                <i class="fas fa-heart"></i>
                                                <span>{{$explore->likes_count}}</span></li>

                                            <li class="rating"><i
                                                    class="fas fa-share"></i><span>{{$explore->shares_count}}</span>
                                            </li>
                                        </ul>
                                    </div>

                                </div>
                            @endforeach


                        </div>
                    @endif
                </div>
            </div>
        </div>

    </section>
    @if(count($relatedShops)>0)
        <section class="inner-section related-part mb-20">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2> {{__('website.related')}} <span> {{__('website.shops')}} </span></h2>
                            <p>
                                {{__('website.related-shops-text')}}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="recomend-slider slider-arrow">
                            @foreach($relatedShops as $relatedShop)
                                <div class="product-card ">
                                    <div class=" product-card-no-shaddow">
                                        <div class="product-img">
                                            <a href="shop.html">
                                                <img src="{{$relatedShop->image()}}" alt="{{$relatedShop->name}}"></a></div>

                                    </div>
                                    <div class="product-content">
                                        <ol class="breadcrumb product-category">
                                            <li><i class="fas fa-tags"></i></li>
                                            @foreach($relatedShop->categories as $category)
                                                <li class="breadcrumb-item"><a
                                                        href="{{$category->slug}}">{{$category->name}}</a></li>
                                            @endforeach

                                        </ol>
                                        <h5 class="product-title"><a
                                                href="{{route('website.shop-details',['id'=>$relatedShop->id,'slug'=>$relatedShop->slug])}}">{{$relatedShop->name}}</a>
                                        </h5>
                                        <div class="product-meta"><span><i class="fas fa-eye"></i>100 {{__('website.views')}}</span><span><i
                                                    class="fas fa-bullhorn"></i>{{$relatedShop->advertisements_count}} {{__('website.ads')}}</span>
                                        </div>

                                        <button type="submit"
                                                class="btn btn-inline btn-secondary post-btn follow-btn mb-2"><i
                                                class="fas fa-user"></i><span>{{__('website.follow')}}</span></button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

            </div>
        </section>
    @endif
    @if(count($relatedAdvertisements)>0)
        <section class="inner-section related-part ">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2> {{__('website.related')}} <span>{{__('website.ads')}}</span></h2>
                            <p>
                                {{__('website.related-ads-text')}}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="recomend-slider slider-arrow">
                            @foreach($relatedAdvertisements as $advertisement)
                                <div class="product-card">
                                    <div class="product-media">
                                        <a href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}">
                                            <div class="product-img"><img src="{{$advertisement->image()}}"
                                                                          alt="product"></div>
                                        </a>
                                        <div class="cross-vertical-badge product-badge"><i
                                                class="fas fa-clipboard-check"></i><span>{{__('website.recommend')}}</span>
                                        </div>
                                        <div class="product-type"><span
                                                class="flat-badge booking">{{$advertisement->name}}</span></div>
                                        <ul class="product-action">
                                            <li class="view"><i
                                                    class="fas fa-eye"></i><span>{{$advertisement->views_count}}</span>
                                            </li>
                                            <li class="click"><i class="fas fa-heart"></i><span>{{$advertisement->views_count}}</span></li>
                                            <li class="rating"><i class="fas fa-star"></i><span>{{$advertisement->average_rate}}/5</span>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="product-content">
                                        <ol class="breadcrumb product-category">
                                            <li><i class="fas fa-tags"></i></li>
                                            <li class="breadcrumb-item"><a href="{{route('website.all-advertisements',['category'=>$advertisement->subCategory->category->slug,'type'=>'View'])}}">{{$advertisement->subCategory->category->name}}</a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><a href="{{route('website.all-advertisements',['category'=>$advertisement->subCategory->slug,'type'=>'View'])}}">{{$advertisement->subCategory->name}}</a></li>
                                        </ol>
                                        <h5 class="product-title"><a
                                                href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}">{{$advertisement->title}}</a>
                                        </h5>
                                        <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>
                                        {{$advertisement->city->name}}</span><span><i class="fas fa-clock"></i>{{$advertisement->created_at}}</span>
                                        </div>
                                        <div class="product-info">
                                            <h5 class="product-price">{{$advertisement->price}}  {{$advertisement->city->country->currency}}
                                               </h5>
                                            <div class="product-btn">
                                                <a href="tel:{{$advertisement->shop->phone}}" title="call"
                                                   class="fas fa-phone-alt"></a>
{{--                                                <a href="{{$advertisement->store_id}}" title="chat"--}}
{{--                                                   class="fas fa-comments"></a>--}}
                                                <button type="button" title="whatsapp"
                                                        onclick="location.href='https://api.whatsapp.com/send?phone={{$advertisement->phone}}'"
                                                        class="fab fa-whatsapp no-top" tabindex="0"></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

            </div>
        </section>
    @endif
    <div id="snackbar">{{__('website.link-copied-to-clipboard')}}</div>

@endsection
@section('extra-models')
    <div class="modal fade" id="ad-share">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>Share this Ad</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="modal-share"><a href="#"><i
                                class="facebook fab fa-facebook-f"></i><span>facebook</span></a><a href="#"><i
                                class="twitter fab fa-twitter"></i><span>twitter</span></a><a href="#"><i
                                class="linkedin fab fa-linkedin"></i><span>linkedin</span></a><a href="#"><i
                                class="link fas fa-link"></i><span>copy link</span></a></div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="report">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>{{__('website.report')}}</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form class="adpost-form" action="{{route('website.report-block')}}" method="post">
                        @csrf
                        <input type="hidden" name="store_id" value="{{$shop->id}}">
                        <input type="hidden" name="type" value="1">
                        <div class="adpost-card">
                            <div class="adpost-title mb-10">
                                <h3>{{__('website.report-this-shop')}}</h3>
                            </div>
                            @if(count($storeReports))
                                <div class="row">
                                    <div class="col-md-12 col-lg-12">
                                        <div class="form-group">
                                            <ul class="form-check-list">
                                                @foreach($storeReports as $storeReport)

                                                    <li class="mb-3">
                                                        <input type="radio" value="{{$storeReport->id}}" name="reason_id" class="form-check"
                                                               id="fix-check{{$storeReport->id}}">
                                                        <label for="fix-check{{$storeReport->id}}"
                                                               class="form-check-text">{{$storeReport->content}}</label>
                                                    </li>
                                                @endforeach

                                            </ul>
                                        </div>
                                    </div>

                                </div>
                            @endif
                            <button type="submit" class="btn btn-inline review-submit">
                                <span>{{__('website.report')}}</span></button>
                        </div>


                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="block">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>{{__('website.block')}}</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    @if ($errors->any())
                        @foreach ($errors->all() as $error)
                            <div class="alert alert-danger inverse alert-dismissible fade show" role="alert"><i
                                    class="icon-thumb-down"></i>

                                <p>{{ $error }}</p>
                                <button class="close" type="button" data-dismiss="alert" aria-label="Close"
                                        data-original-title="" title=""><span aria-hidden="true">×</span></button>

                            </div>

                        @endforeach
                    @endif

                    <form class="adpost-form" action="{{route('website.report-block')}}" method="post">
                        @csrf
                        <input type="hidden" name="store_id" value="{{$shop->id}}">
                        <input type="hidden" name="type" value="2">

                        <div class="adpost-card">
                            <div class="adpost-title mb-10">
                                <h3>{{__('website.block-this-shop')}}</h3>
                            </div>
                            @if(count($storeBlocks))
                                <div class="row">
                                    <div class="col-md-12 col-lg-12">
                                        <div class="form-group">
                                            <ul class="form-check-list">
                                                @foreach($storeBlocks as $storeBlock)

                                                    <li class="mb-3">
                                                        <input type="radio" value="{{$storeBlock->id}}" name="reason_id" class="form-check"
                                                               id="fix-check{{$storeBlock->id}}">
                                                        <label for="fix-check{{$storeBlock->id}}"
                                                               class="form-check-text">{{$storeBlock->content}}</label>
                                                    </li>
                                                @endforeach

                                            </ul>
                                        </div>
                                    </div>

                                </div>
                            @endif
                            <button type="submit" class="btn btn-inline review-submit">
                                <span>{{__('website.block')}}</span></button>
                        </div>


                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="profile-share">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>Share this Profile</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="modal-share"><a
                            href="https://www.facebook.com/sharer.php?u={{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}"><i
                                class="facebook fab fa-facebook-f"></i><span>facebook</span></a>
                        <a href="https://twitter.com/intent/tweet?text={{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}"><i
                                class="twitter fab fa-twitter"></i><span>twitter</span></a>
                        <a href="https://api.whatsapp.com/send/?text={{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}"><i
                                class="whatsapp-social fab fa-whatsapp"></i><span>whatsapp</span></a>
                        <a href="javascript:myFunction('{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}')"><i
                                class="link fas fa-link"></i><span>copy link</span></a></div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="number">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>Contact this Number</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <h3 class="modal-number"><a href="tel:{{$shop->phone}}">{{$shop->phone}}</a></h3>
                </div>
            </div>
        </div>
    </div>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
    <a href="https://api.whatsapp.com/send?phone=+{{$shop->phone}}&text=Hello%2C+Admin%21%0D%0AI+want+to+contact+you"
       class="float" target="_blank">
        <i class="fa fa-whatsapp top-5 my-float"></i></a>

    <a href="tel:{{$shop->phone}}" class="float2" target="_blank">
        <i class="fa fa-phone top-5 my-float2"></i></a>

    {{--    <a href="message-details.html" class="float3" target="_blank">--}}
    {{--        <i class="fas fa-comments top-5 my-float3"></i></a>--}}

@endsection
@section('extra-js-files')
    <script>

        $(document).ready(function () {

            $('ul.tabs li').click(function () {
                var tab_id = $(this).attr('data-tab');

                $('ul.tabs li').removeClass('current');
                $('.tab-content').removeClass('current');

                $(this).addClass('current');
                $("#" + tab_id).addClass('current');
            })

        })

    </script>
    <!-- image gallery -->
    <script src='https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.8.2/js/lightbox-plus-jquery.min.js'></script>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js'></script>
    <script>
        function myFunction(link) {
            //window.location.href
            navigator.clipboard.writeText(link);
            var x = document.getElementById("snackbar");
            x.className = "show";
            setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

        }


    </script>

@endsection
@if(auth()->user())

{{--    <script defer src="https://widget-js.cometchat.io/v3/cometchatwidget.js"></script>--}}
{{--    <script>--}}

{{--        window.addEventListener('DOMContentLoaded', (event) => {--}}
{{--            CometChatWidget.init({--}}
{{--                "appID": "{{env('COMETCHAT_APP_ID')}}",--}}
{{--                "appRegion": "{{env('COMETCHAT_REGION')}}",--}}
{{--                "authKey": "{{env('COMETCHAT_RESET_API_Key')}}"--}}
{{--            }).then(response => {--}}
{{--                console.log("Initialization completed successfully");--}}

{{--                const user = new CometChatWidget.CometChat.User("store_{{$shop->id}}");--}}
{{--                user.setName("{{auth()->user()->name}}");--}}

{{--                CometChatWidget.createOrUpdateUser(user).then((user) => {--}}

{{--                    //You can now call login function.--}}
{{--                    CometChatWidget.login({--}}
{{--                        "uid": "store_{{$shop->id}}"--}}
{{--                    }).then(response => {--}}
{{--                        CometChatWidget.launch({--}}
{{--                            "widgetID": "{{env('COMETCHAT_WIDGET_ID')}}",--}}
{{--                            "docked": "true",--}}
{{--                            "alignment": "right", //left or right--}}
{{--                            "roundedCorners": "true",--}}
{{--                            "height": "450px",--}}
{{--                            "width": "400px",--}}

{{--                            "defaultType": 'user' //user or group--}}
{{--                        });--}}
{{--                    }, error => {--}}
{{--                        console.log("User login failed with error:", error);--}}
{{--                        //Check the reason for error and take appropriate action.--}}
{{--                    });--}}
{{--                }, error => {--}}
{{--                    console.log("Initialization failed with error:", error);--}}
{{--                    //Check the reason for error and take appropriate action.--}}
{{--                });--}}
{{--            });--}}
{{--        });--}}
{{--    </script>--}}
@endif
