@extends('Website.layouts.app')

@section('banner')
    <section class="inner-section single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.shops')}}
                        </h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.shops')}}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('page-title')
    {{__('website.shops')}}
@endsection

@section('content')
    <section class="inner-section ad-list-part">
        <div class="container">
            <div class="row content-reverse">
                <div class="col-lg-4 col-xl-3 hidden-small-2">
                    <div class="row sticky">
                        <form method="POST" action="{{route('website.all-shops',$cityName)}}">
                           @csrf
                        <div class="col-md-6 col-lg-12">

                        </div>
                        <div class="col-md-6 col-lg-12">
                            <div class="product-widget">
                                <h6 class="product-widget-title">{{__('website.filter-by-rating')}}</h6>
                                <div class="product-widget-form">
                                    <ul class="product-widget-list">
                                        @if(count($rates)>0)
                                            @foreach($rates as $rate=>$shopsRate)
                                                <li class="product-widget-item">
                                                    <div class="product-widget-checkbox"><input type="checkbox"
                                                                                                id="chcekrate{{$rate}}"
                                                                                                name="rates[]">
                                                    </div>
                                                    <label class="product-widget-label" for="chcekrate{{$rate}}">
                                                <span class="product-widget-star">

                                                    @for($i=0; $i<$rate; $i++)
                                                        <i class="fas fa-star"></i>
                                                    @endfor
                                                    @for($i=0; $i<(5-$rate); $i++)
                                                        <i class="far fa-star"></i>
                                                    @endfor
                                                </span>
                                                        <span
                                                            class="product-widget-number">({{count($shopsRate)}})</span></label>
                                                </li>
                                            @endforeach
                                        @endif
                                    </ul>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-12">
                            <div class="product-widget">
                                <h6 class="product-widget-title">{{__('website.filter-by-cities')}}</h6>
                                <form class="product-widget-form">
                                    <div class="product-widget-search"><input type="text"
                                                                              placeholder="{{__('website.search')}}">
                                    </div>
                                    <ul class="product-widget-list product-widget-scroll">
                                        @if(count($cities))
                                            @foreach($cities as $city)
                                                <li class="product-widget-item">
                                                    <div class="product-widget-checkbox">
                                                        <input type="checkbox" value="{{$city->id}}" id="chcekcity{{$city->id}}" name="cities[]">
                                                    </div>
                                                    <label class="product-widget-label" for="chcekcity{{$city->id}}"><span
                                                            class="product-widget-text">{{$city->name}}</span><span
                                                            class="product-widget-number">({{$city->shops_count}})</span></label>
                                                </li>
                                            @endforeach
                                        @endif
                                    </ul>
                                </form>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-12">

                        </div>
                        <div class="col-md-6 col-lg-12">
                            <div class="product-widget">
                                <h6 class="product-widget-title">{{__('website.filter-by-cities')}}</h6>
                                <form class="product-widget-form">
                                    <div class="product-widget-search"><input type="text"
                                                                              placeholder="{{__('website.search')}}">
                                    </div>
                                    <ul class="product-widget-list product-widget-scroll">
                                        @if(count($categories))
                                            @foreach($categories as $category)
                                                <li class="product-widget-item">
                                                    <div class="product-widget-checkbox">
                                                        <input type="checkbox" value="{{$category->id}}" id="chcekcategory{{$category->id}}" name="categories[]">
                                                    </div>
                                                    <label class="product-widget-label" for="chcekcategory{{$category->id}}"><span
                                                            class="product-widget-text">{{$category->name}}</span><span
                                                            class="product-widget-number">({{$category->shops_count}})</span></label>
                                                </li>
                                            @endforeach
                                        @endif
                                    </ul>
{{--                                    <button type="submit" onclick="document.getElementByName('categories').value = ''" class="product-widget-btn"><i--}}
{{--                                            class="fas fa-broom"></i><span>{{__('website.clear-filter')}}</span></button>--}}
                                    <button type="submit" onclick="document.getElementByName('categories').value = ''" class="product-widget-btn"><i
                                            class="fas fa-broom"></i><span>{{__('website.search')}}</span></button>
                                </form>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-8 col-xl-9">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="header-filter">
                                <div class="filter-show"><label class="filter-label">{{__('website.show')}} :</label>
                                    <select onchange="this.options[this.selectedIndex].value && (window.location = '{{route('website.all-shops',$cityName)}}'+'?pages='+this.options[this.selectedIndex].value);"class="custom-select filter-select">
                                        <option value="12">12</option>
                                        <option value="24">24</option>
                                        <option value="36">36</option>
                                    </select></div>
                                <button type="button" class="header-widget sidebar-btn2 d-xl-hidden d-md-none"><i
                                        class="fas fa-filter"></i></button>
                                <div class="filter-short"><label class="filter-label">{{__('website.sort-by')}} :</label>
                                    <select onchange="this.options[this.selectedIndex].value && (window.location = '{{route('website.all-shops',$cityName)}}'+'?sortBy='+this.options[this.selectedIndex].value);"class="custom-select filter-select">
                                        <option value="default">{{__('website.default')}}</option>
                                        <option value="rated">{{__('website.most-rated')}}</option>
                                        <option value="date">{{__('website.recent')}}</option>
                                    </select>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="ad-feature-slider slider-arrow">
                                @if(count($premiumAds)>0)
                                    @foreach($premiumAds as $premiumAd)
                                <div class="feature-card">
                                    <a href="#" class="feature-img">
                                        <img src="{{ $premiumAd->image()}}" alt="feature"></a>
                                    <div class="cross-inline-badge feature-badge"><span>@if($premiumAd->is_negotiable==0) {{__('website.negotiable')}} @else {{__('website.not-negotiable')}} @endif</span><i
                                            class="fas fa-book-open"></i></div>
                                    <button type="button"
                                            class="feature-wish"><i class="fas fa-heart"></i></button>
                                    <div class="feature-content">
                                        <ol class="breadcrumb feature-category">
                                            <li><span class="flat-badge rent">rent</span></li>
                                            <li class="breadcrumb-item"><a href="#">{{$premiumAd->subCategory->category->name}}</a></li>
                                            <li class="breadcrumb-item active" aria-current="page">{{$premiumAd->subCategory->name}}</li>
                                        </ol>
                                        <h3 class="feature-title"><a href="{{route('website.advertisement-details',['id'=>$premiumAd->id,'slug'=>$premiumAd->slug])}}">{{$premiumAd->title}}</a></h3>
                                        <div class="feature-meta"><span
                                                class="feature-price">{{$premiumAd->price}}</span><span
                                                class="feature-time"><i class="fas fa-clock"></i>{{$premiumAd->created_at}}</span>
                                        </div>
                                    </div>
                                </div>
                                    @endforeach
                                    @endif
                            </div>
                        </div>
                    </div>
                    @if(count($shops)>0)

                    <div class="row justify-content-center">
                            @foreach($shops as $shop)
                        <div class="col-md-11 col-lg-8 col-xl-6">
                            <div class="product-card standard">
                                <div class="product-media shop-media">
                                    <div class="product-img shop-img">
                                        <a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}">
                                        <img src="{{$shop->image()}}" alt="{{$shop->name}}">
                                        </a>
                                    </div>


                                </div>
                                <div class="product-content">
                                    <ol class="breadcrumb product-category">
                                        <li><i class="fas fa-tags"></i></li>
                                        @foreach($shop->categories as $category)
                                        <li class="breadcrumb-item"><a href="{{route('website.all-advertisements',$category->slug)}}">{{$category->name}}</a></li>
                                        @endforeach
{{--                                        <li class="breadcrumb-item active" aria-current="page">house</li>--}}
                                    </ol>
                                    <h5 class="product-title"><a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}">{{$shop->name}}</a></h5>
                                    <div class="product-meta"><span><i class="fas fa-eye"></i>{{$shop->views_count}} {{__('website.views')}}</span><span><i
                                                class="fas fa-bullhorn"></i>{{$shop->advertisements_count}} {{__('website.ads')}}</span></div>
                                   @if(auth()->user())
                                    <button type="submit"  onclick="follow({{$shop->id}})"
                                            class="btn btn-inline @if($shop->is_follow==0) btn-secondary @endif post-btn follow-btn mb-2 "  id="follow-{{$shop->id}}">
                                        @if($shop->is_follow==0)
                                            <i class="fas fa-user"></i>
                                            <span>
                                                    {{__('website.follow')}}
                                                </span>

                                        @else
                                            <i class="fas fa-user-times"></i>
                                            <span>
                                                    {{__('website.un-follow')}}
                                                </span>

                                        @endif
                                    </button>
                                    @endif
                                </div>
                            </div>

                        </div>
                            @endforeach
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="footer-pagection">
                                <p class="page-info">{{__('website.Showing')}} {{$shops->total()}} {{__('website.of')}} {{$shops->perPage()}} {{__('website.results')}}</p>

                                {{$shops->links()}}

                            </div>

                        </div>
                    </div>
                    @else
                        @include('Website.pages.errors.empty')


                    @endif

                </div>
            </div>
        </div>
    </section>
@endsection
@section('extra-js-files')
    <script>
        $(".menu2").click(function () {
            $(".menu2").addClass('selected').siblings().removeClass('selected');
        });

    </script>
@endsection
