@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{app()->getLocale()=='en'?asset('website/css/custom/blog-details.css'):asset('website/css/custom/blog-details-rtl.css')}}">

@endsection

@section('banner')

    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1> {{__('website.viewers')}} </h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item"><a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}">{{$shop->name}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.viewers')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('page-title')
    {{__('website.views')}}
@endsection

@section('content')

    <section class="blog-details-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">



                    <div class="common-card no-padding" id="review">
                        <div class="card-header">
                            <h5 class="card-title">{{__('website.viewers')}}
                                ({{count($shop->views)}})</h5>
                        </div>
                        @if(count($viewers))
                            <div class="ad-details-review">
                                <ul class="review-list">
                                    @foreach($viewers as $viewer)
                                        <li class="review-item follower-item">
                                            <div class="review-user">
                                                <div class="review-head no-mb">
                                                    <div class="review-profile"><a href="javascript:void(0)" class="review-avatar"><img src="{{$viewer->image()??'/website/images/avatar/profile-default.png'}}" alt="{{$viewer->name}}"></a>
                                                        <div class="review-meta">
                                                            <h6><a href="javascript:void(0)">{{$viewer->name??__('website.visitor')}}</a></h6>
                                                            <p> {{__('website.moon-user')}} </p>

                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </li>
                                    @endforeach
                                </ul>


                            </div>
                        @endif
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="footer-pagection">
                                <p class="page-info">{{__('website.Showing')}} {{$viewers->total()}} {{__('website.of')}} {{$viewers->perPage()}} {{__('website.results')}}</p>

                                {{$viewers->links()}}

                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>

    </section>
@endsection
