<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V100\Auth\AuthController;
use App\Http\Controllers\Api\V100\SetFirebaseToken;
use App\Http\Controllers\Api\V100\GetCountries;
use App\Http\Controllers\Api\V100\Story\StoryController;
use App\Http\Controllers\Api\V100\Home\GetHome;
use App\Http\Controllers\Api\V100\Profile\ProfileController;
use App\Http\Controllers\Api\V100\Follow\StoreFollower;
use App\Http\Controllers\Api\V100\CategoryController;
use App\Http\Controllers\Api\V100\Advertisement\AdvertisementController;
use App\Http\Controllers\Api\V100\Advertisement\GetFilterResults;
use App\Http\Controllers\Api\V100\Advertisement\UserAdvertisementAction;
use App\Http\Controllers\Api\V100\Store\StoreController;
use App\Http\Controllers\Api\V100\Explore\ExploreController;
use App\Http\Controllers\Api\V100\Map\GetMapDetails;
use App\Http\Controllers\Api\V100\NotificationController;
use App\Http\Controllers\Api\V100\Settings\SetContactUs;
use App\Http\Controllers\Api\V100\Settings\GetSettings;

Route::prefix('/v1')->group(function () {
    Route::get('settings', GetSettings::class);

    Route::get('countries', GetCountries::class);

    Route::get('stories', [StoryController::class, 'index']);

    Route::get('home', GetHome::class);

    Route::get('categories', [CategoryController::class, 'index']);
    Route::get('sub-categories', [CategoryController::class, 'subCategories']);

    Route::prefix('advertisements')->controller(AdvertisementController::class)->group(function () {
        Route::get('/','index');
        Route::get('{advertisement}','show');
        Route::get('{advertisement}/reviews','reviews');
    });

    Route::prefix('stores')->controller(StoreController::class)->group(function () {
        Route::get('/','index');
        Route::get('{store}','show');
    });

    Route::apiResource('explores', ExploreController::class);

    Route::get('map', GetMapDetails::class);

    Route::get('filter', GetFilterResults::class);

    Route::post('contact-us', SetContactUs::class);

    Route::post('authentication', [AuthController::class, 'authentication']);

    Route::prefix('auth')->controller(AuthController::class)->group(function () {
        Route::post('social/login','socialLogin');
        Route::post('verify_code','verifyCode');
        Route::post('send_code','sendCode');
    });

    Route::middleware('auth:sanctum')->group(function() {
        Route::post('auth/logout', [AuthController::class, 'logout']);
        Route::post('firebase_token', SetFirebaseToken::class);

        Route::post('follow', StoreFollower::class);

        Route::post('stories/seen', [StoryController::class, 'seen']);

        Route::controller(UserAdvertisementAction::class)->group(function () {
            Route::post('favorite', 'favorite');
            Route::post('share', 'share');
            Route::post('report', 'report');
        });

        Route::post('store/report',[StoreController::class, 'report']);

        Route::post('store/block',[StoreController::class, 'block']);

        Route::prefix('profile')->controller(ProfileController::class)->group(function () {
            Route::post('/','update');
            Route::get('followings','followings');
            Route::get('advertisements','advertisements');
        });

        Route::apiResource('notifications', NotificationController::class, ['only' => ['index', 'destroy']]);
    });
});

include 'ajax.php';
