<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('website.home-page')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('banner'); ?>
    <section class="banner-part">
        <div class="container">
            <div class="banner-content">
                <h1><?php echo e(__('website.banner-title')); ?></h1>
                <p><?php echo e(__('website.banner-description')); ?></p>
                <a href="<?php echo e(route('website.all-categories')); ?>" class="btn btn-inline"><i class="fas fa-eye"></i><span>
                        <?php echo e(__('website.view-all-categories')); ?>

                    </span></a>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="suggest-part hidden-small-2 ">
        <div class="container">
            <div class="suggest-slider slider-arrow">
                <?php if(count($categories)>0): ?>
                    <?php $__currentLoopData = $categories->where('app_home', 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('website.all-advertisements',$category->slug)); ?>?type=View" class="suggest-card">
                            <img src="<?php echo e($category->image()); ?>" alt="<?php echo e($category->name); ?>" width="100px" height="100px">
                            <h6><?php echo e($category->name); ?></h6>
                            <p>(<?php echo e($category->category_advertisements_count); ?>) <?php echo e(__('website.ads')); ?></p>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

            </div>
        </div>
    </section>
    <section class="section recomend-part d-lg-none d-md-none">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2> &nbsp; <span><?php echo e(__('website.moon')); ?></span> <?php echo e(__('website.categories')); ?></h2>
                        <p>
                            <?php echo e(__('website.banner-description')); ?>

                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="container">
                        <?php if(count($categories)>0): ?>
                            <?php $__currentLoopData = $categories->where('app_home', 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <a href="<?php echo e(route('website.all-advertisements',['category'=>$category->slug,'type'=>'view'])); ?>" class="suggest-card suggest-card-mobile  ">

                                    <img
                                        src="<?php echo e($category->image()); ?>" alt="<?php echo e($category->name); ?>">
                                    <h6><?php echo e($category->name); ?></h6>
                                    <p>(<?php echo e($category->category_advertisements_count); ?>) <?php echo e(__('website.ads')); ?></p>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                    </div>
                </div>
            </div>

        </div>
    </section>

    <section class="section recomend-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2><span><?php echo e(__('website.moon')); ?></span> &nbsp; <?php echo e(__('website.shop-stories')); ?></h2>
                        <p>
                            <?php echo e(__('website.shop-stories-desc')); ?>

                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">

                    <div id="stories" class="storiesWrapper"></div>
                    <div class="center-50"><a href="<?php echo e(route('website.all-stories')); ?>" class="btn btn-inline"><i
                                class="fas fa-eye"></i><span> <?php echo e(__('website.view-all-stories')); ?> </span></a></div>
                </div>
            </div>

        </div>


    </section>
    <section class="section category-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2><?php echo e(__('website.top-categories-by')); ?> &nbsp;<span><?php echo e(__('website.ads')); ?></span></h2>
                        <p>
                            <?php echo e(__('website.top-categories-desc')); ?>

                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php if(count($categories)>0): ?>
                    <?php $__currentLoopData = $categories->where('app_home', 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                            <div class="category-card">
                                <div class="category-head">
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    
                                    

                                    <img src="<?php echo e($category->image()); ?>" alt="<?php echo e($category->name); ?>" width="255px" height="200px">
                                    <a href="<?php echo e(route('website.all-advertisements',$category->slug)); ?>?type=View"
                                       class="category-content">
                                        <h4><?php echo e($category->name); ?></h4>
                                        <p>(<?php echo e($category->category_advertisements_count); ?>)</p>
                                    </a>
                                </div>
                                <ul class="category-list">
                                    <?php $__currentLoopData = $category->subCategories->sortByDesc('advertisements_count'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <li><a href="<?php echo e(route('website.all-advertisements',$subCategory->slug)); ?>?type=View">
                                                <h6><?php echo e($subCategory->name); ?></h6>
                                                <p>(<?php echo e($subCategory->advertisements_count); ?>)</p>
                                            </a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>

                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-20"><a href="<?php echo e(route('website.all-categories')); ?>" class="btn btn-inline"><i
                                class="fas fa-eye"></i><span><?php echo e(__('website.view-all-categories')); ?></span></a></div>
                </div>
            </div>
        </div>
    </section>
    <section class="section recomend-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2 > <?php echo e(__('website.top-rated')); ?> &nbsp;

                            <span> <?php echo e(__('website.shops')); ?> </span>

                        </h2>
                        <p>
                            <?php echo e(__('website.top-rated-desc')); ?>


                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="recomend-slider slider-arrow">
                        <?php if(count($shops)>0): ?>
                            <?php $__currentLoopData = $shops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="product-card shops ">
                                    <div class=" product-card-no-shaddow">
                                        <div class="product-img">
                                            <a href="<?php echo e(route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])); ?>" class="home-shop-image"><img
                                                    src="<?php echo e($shop->image()); ?>" alt="<?php echo e($shop->name); ?>" width="256px" height="170px"></a>
                                        </div>

                                    </div>
                                    <div class="product-content">
                                        <ol class="breadcrumb product-category">
                                            <li><i class="fas fa-tags"></i></li>
                                            <?php $__currentLoopData = $shop->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="breadcrumb-item"><a
                                                        href="<?php echo e(route('website.all-advertisements',$category->slug)); ?>?type=View"><?php echo e($category->name); ?></a></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ol>
                                        <h5 class="product-title"><a
                                                href="<?php echo e(route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])); ?>"><?php echo e($shop->name); ?></a>
                                        </h5>
                                        <div class="product-meta"><span><i class="fas fa-eye"></i><?php echo e($shop->views_count); ?> <?php echo e(__('website.views')); ?></span><span><i
                                                    class="fas fa-bullhorn"></i><?php echo e($shop->advertisements_count); ?> <?php echo e(__('website.ads')); ?></span>
                                        </div>

                                        <?php if(auth()->user()): ?>
                                            <button type="submit"
                                                    onclick="follow(<?php echo e($shop->id); ?>)"
                                                    class="btn btn-inline  <?php if($shop->is_follow==0): ?> btn-secondary <?php endif; ?>  post-btn follow-btn mb-2" id="follow-<?php echo e($shop->id); ?>">
                                                <?php if($shop->is_follow==0): ?>
                                                    <i
                                                        class="fas fa-user"></i><span> <?php echo e(__('website.follow')); ?>  </span>
                                                <?php else: ?>
                                                    <i
                                                        class="fas fa-user-times"></i><span> <?php echo e(__('website.un-follow')); ?>  </span>
                                                <?php endif; ?>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-50"><a href="<?php echo e(route('website.all-shops','all')); ?>" class="btn btn-inline"><i
                                class="fas fa-eye"></i><span><?php echo e(__('website.view-all-shops')); ?></span></a></div>
                </div>
            </div>
        </div>
    </section>
    <?php if(auth()->user() && count($followedShops)>0): ?>
        <section class="section recomend-part" id="follow-section">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2> <?php echo e(__('website.followed')); ?> &nbsp;
                                <span> <?php echo e(__('website.shops')); ?> </span></h2>
                            <p>
                                <?php echo e(__('website.followed-shop-desc')); ?>



                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="recomend-slider slider-arrow">
                            <?php $__currentLoopData = $followedShops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="product-card shops" id="follow-section-<?php echo e($shop->id); ?>">
                                    <div class=" product-card-no-shaddow">
                                        <div class="product-img">
                                            <a href="<?php echo e(route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])); ?>"><img
                                                    src="<?php echo e($shop->image()); ?>" alt="<?php echo e($shop->name); ?>" width="256px" height="170px">
                                            </a>
                                        </div>

                                    </div>
                                    <div class="product-content">
                                        <ol class="breadcrumb product-category">
                                            <li><i class="fas fa-tags"></i></li>
                                            <?php $__currentLoopData = $shop->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="breadcrumb-item"><a
                                                        href="<?php echo e($category->slug); ?>"><?php echo e($category->name); ?></a></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            
                                        </ol>
                                        <h5 class="product-title">
                                            <a href="<?php echo e(route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])); ?>"><?php echo e($shop->name); ?></a>
                                        </h5>
                                        <div class="product-meta"><span><i class="fas fa-eye"></i>100 <?php echo e(__('website.views')); ?></span><span><i
                                                    class="fas fa-bullhorn"></i><?php echo e($shop->advertisements_count); ?> <?php echo e(__('website.ads')); ?></span>
                                        </div>

                                        <button type="button"
                                                onclick="follow(<?php echo e($shop->id); ?>)"
                                                class="btn btn-inline post-btn follow-btn mb-2" id="follow-<?php echo e($shop->id); ?>"><i
                                                class="fas fa-user-times"></i><span><?php echo e(__('website.un-follow')); ?></span>
                                        </button>


                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="center-50">
                            <a href="<?php echo e(route('website.view-all-followed-shops')); ?>" class="btn btn-inline">
                                <i class="fas fa-eye"></i>
                                <span><?php echo e(__('website.view-all-followed-shops')); ?></span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <?php if($settings[\App\Helpers\Constant::SETTING_KEYS['Suggested ads']]->show_app==1): ?>
        <section class="section recomend-part">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2><?php echo e(__('website.our-recommended')); ?> &nbsp;
                                <span><?php echo e(__('website.ads')); ?></span></h2>
                            <p>
                                <?php echo e(__('website.our-recommended-ads-desc')); ?>



                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="recomend-slider slider-arrow">
                            
                            <?php if(count($suggestedAdvertisements)>0): ?>
                                <?php $__currentLoopData = $suggestedAdvertisements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $advertisement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="product-card">
                                        <div class="product-media">
                                            <a href="<?php echo e(route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])); ?>?type=View">
                                                <div class="product-img"><img src="<?php echo e($advertisement->image()); ?>"
                                                                              alt="<?php echo e($advertisement->title); ?>" width="256px" height="170px"></div>
                                            </a>
                                            <div class="cross-vertical-badge product-badge"><i
                                                    class="fas fa-clipboard-check"></i><span><?php echo e(__('website.recommend')); ?></span>
                                            </div>
                                            <div class="product-type"><span
                                                    class="flat-badge booking"> <?php if($advertisement->premium==1): ?><?php echo e(__('website.premium')); ?> <?php else: ?> <?php echo e(__('website.regular')); ?> <?php endif; ?></span></div>
                                            <ul class="product-action">
                                                <li class="view"><i
                                                        class="fas fa-eye"></i><span><?php echo e($advertisement->views_count); ?></span>
                                                </li>
                                                <li class="click"><i class="fas fa-heart"></i><span><?php echo e($advertisement->favorite_count); ?></span></li>
                                                <li class="rating"><i class="fas fa-star"></i><span><?php echo e($advertisement->average_rate); ?>/5</span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="product-content">
                                            <ol class="breadcrumb product-category">
                                                <li><i class="fas fa-tags"></i></li>
                                                <li class="breadcrumb-item"><a href="<?php echo e(route('website.all-advertisements',['category'=>$advertisement->subCategory->category->slug,'type'=>'View'])); ?>"><?php echo e($advertisement->subCategory->category->name); ?></a>
                                                </li>

                                                <li class="breadcrumb-item active"><a
                                                        href="<?php echo e(route('website.all-advertisements',['category'=>$advertisement->subCategory->slug,'type'=>'View'])); ?>"><?php echo e($advertisement->subCategory->name); ?></a>
                                                </li>
                                            </ol>
                                            <h5 class="product-title"><a
                                                    href="<?php echo e(route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug,'type'=>'View'])); ?>"><?php echo e($advertisement->title); ?></a>
                                            </h5>
                                            <div class="product-meta">
                                                <span><i class="fas fa-map-marker-alt"></i>
                                        <?php echo e($advertisement->city?$advertisement->city->name:'-'); ?>,<?php echo e($advertisement->city&&$advertisement->city->country?$advertisement->city->country->name:'-'); ?>

                                                </span>
                                                <span><i class="fas fa-clock"></i><?php echo e(\Carbon\Carbon::createFromTimeStamp(strtotime($advertisement->created_at))->diffForHumans()); ?></span>
                                            </div>
                                            <div class="product-info">
                                                <h5 class="product-price"><?php echo e($advertisement->price); ?> <?php echo e($advertisement->city->country->currency); ?>

                                                </h5>
                                                <div class="product-btn">
                                                    <a href="tel:<?php echo e($advertisement->shop->phone); ?>" title="call"
                                                       class="fas fa-phone-alt"></a>
                                                    
                                                    
                                                    <button type="button" title="whatsapp"
                                                            onclick='window.open("https://api.whatsapp.com/send?phone=<?php echo e($advertisement->phone!=null??$advertisement->shop->phone); ?>")'
                                                            class="fab fa-whatsapp no-top" tabindex="0"></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="center-50"><a href="<?php echo e(route('website.all-advertisements','all')); ?>?type=View"
                                                  class="btn btn-inline"><i
                                    class="fas fa-eye"></i><span><?php echo e(__('website.view-all-recommend')); ?></span></a></div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <?php if($settings[App\Helpers\Constant::SETTING_KEYS['Most popular ads']]->show_app==1): ?>
        <section class="section recomend-part">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2><?php echo e(__('website.our-trending')); ?> &nbsp;
                                <span><?php echo e(__('website.ads')); ?></span></h2>
                            <p>
                                <?php echo e(__('website.our-trending-ads-desc')); ?>



                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="recomend-slider slider-arrow">
                            
                            <?php if(count($mostPopularAdvertisements)>0): ?>
                                <?php $__currentLoopData = $mostPopularAdvertisements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mostPopularAdvertisement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="product-card">
                                        <div class="product-media">
                                            <a href="<?php echo e(route('website.advertisement-details',['id'=>$mostPopularAdvertisement->id,'slug'=>$mostPopularAdvertisement->slug])); ?>?type=View">
                                                <div class="product-img"><img src="<?php echo e($mostPopularAdvertisement->image()); ?>"
                                                                              alt="<?php echo e($mostPopularAdvertisement->title); ?>" width="256px" height="170px"></div>
                                            </a>
                                            <div class="cross-vertical-badge product-badge"><i
                                                    class="fas fa-clipboard-check"></i><span><?php echo e(__('website.recommend')); ?></span>
                                            </div>
                                            <div class="product-type"><span
                                                    class="flat-badge booking"> <?php if($mostPopularAdvertisement->premium==1): ?><?php echo e(__('website.premium')); ?> <?php else: ?> <?php echo e(__('website.regular')); ?> <?php endif; ?></span></div>
                                            <ul class="product-action">
                                                <li class="view"><i
                                                        class="fas fa-eye"></i><span><?php echo e($mostPopularAdvertisement->views_count); ?></span>
                                                </li>
                                                <li class="click"><i class="fas fa-heart"></i><span><?php echo e($mostPopularAdvertisement->favorite_count); ?></span></li>
                                                <li class="rating"><i class="fas fa-star"></i><span><?php echo e($mostPopularAdvertisement->average_rate); ?>/5</span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="product-content">
                                            <ol class="breadcrumb product-category">
                                                <li><i class="fas fa-tags"></i></li>
                                                <li class="breadcrumb-item"><a href="<?php echo e(route('website.all-advertisements',['category'=>$mostPopularAdvertisement->subCategory->category->slug,'type'=>'View'])); ?>"><?php echo e($mostPopularAdvertisement->subCategory->category->name); ?></a>
                                                </li>

                                                <li class="breadcrumb-item active"><a
                                                        href="<?php echo e(route('website.all-advertisements',['category'=>$mostPopularAdvertisement->subCategory->slug,'type'=>'View'])); ?>"><?php echo e($mostPopularAdvertisement->subCategory->name); ?></a>
                                                </li>
                                            </ol>
                                            <h5 class="product-title"><a
                                                    href="<?php echo e(route('website.advertisement-details',['id'=>$mostPopularAdvertisement->id,'slug'=>$mostPopularAdvertisement->slug,'type'=>'View'])); ?>"><?php echo e($mostPopularAdvertisement->title); ?></a>
                                            </h5>
                                            <div class="product-meta">
                                                <span><i class="fas fa-map-marker-alt"></i>
                                        <?php echo e($mostPopularAdvertisement->city?$mostPopularAdvertisement->city->name:'-'); ?>,<?php echo e($mostPopularAdvertisement->city&&$mostPopularAdvertisement->city->country?$mostPopularAdvertisement->city->country->name:'-'); ?>

                                                </span>
                                                <span><i class="fas fa-clock"></i><?php echo e(\Carbon\Carbon::createFromTimeStamp(strtotime($mostPopularAdvertisement->created_at))->diffForHumans()); ?></span>
                                            </div>
                                            <div class="product-info">
                                                <h5 class="product-price"><?php echo e($mostPopularAdvertisement->price); ?> <?php echo e($mostPopularAdvertisement->city->country->currency); ?>

                                                </h5>
                                                <div class="product-btn">
                                                    <a href="tel:<?php echo e($mostPopularAdvertisement->shop->phone); ?>" title="call"
                                                       class="fas fa-phone-alt"></a>
                                                    
                                                    
                                                    <button type="button" title="whatsapp"
                                                            onclick='window.open("https://api.whatsapp.com/send?phone=<?php echo e($mostPopularAdvertisement->phone!=null??$mostPopularAdvertisement->shop->phone); ?>")'
                                                            class="fab fa-whatsapp no-top" tabindex="0"></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="center-50"><a href="<?php echo e(route('website.all-advertisements','all')); ?>?type=View"
                                                  class="btn btn-inline"><i
                                    class="fas fa-eye"></i><span><?php echo e(__('website.view-all-trending')); ?></span></a></div>
                    </div>
                </div>
            </div>
        </section>

    <?php endif; ?>
    <?php if(count($categories)>0): ?>
        <?php $__currentLoopData = $categories->where('app_home', 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(count($category->categoryAdvertisements->take(10))>0): ?>

                <section class="section recomend-part">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="section-center-heading">
                                    <h2><?php echo e($category->name); ?> &nbsp;
                                        <span><?php echo e(__('website.ads')); ?></span></h2>
                                    <p>
                                        <?php echo e(__('website.our-trending-ads-desc')); ?>


                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="recomend-slider slider-arrow">
                                    <?php $__currentLoopData = $category->categoryAdvertisements->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $advertisement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="product-card">
                                            <div class="product-media">
                                                <a href="<?php echo e(route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])); ?>?type=View">
                                                    <div class="product-img"><img
                                                            src="<?php echo e($advertisement->image()); ?>" alt="<?php echo e($advertisement->title); ?>" width="256px" height="170px">
                                                    </div>
                                                </a>
                                                <div class="cross-vertical-badge product-badge"><i
                                                        class="fas fa-clipboard-check"></i><span><?php echo e(__('website.recommend')); ?></span>
                                                </div>
                                                <div class="product-type"><span
                                                        class="flat-badge booking"><?php if($advertisement->premium==1): ?><?php echo e(__('website.premium')); ?> <?php else: ?> <?php echo e(__('website.regular')); ?><?php endif; ?></span>
                                                </div>
                                                <ul class="product-action">
                                                    <li class="view"><i
                                                            class="fas fa-eye"></i><span><?php echo e($advertisement->views_count); ?></span>
                                                    </li>
                                                    <li class="click"><i class="fas fa-heart
"></i><span>134</span></li>
                                                    <li class="rating"><i class="fas fa-star"></i><span><?php echo e($advertisement->average_rate); ?>/5</span>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="product-content">
                                                <ol class="breadcrumb product-category">
                                                    <li><i class="fas fa-tags"></i></li>
                                                    <li class="breadcrumb-item"><a href="<?php echo e(route('website.all-advertisements',$advertisement->subCategory->slug)); ?>?type=View"><?php echo e($advertisement->subCategory->category->name); ?></a>
                                                    </li>
                                                    <li class="breadcrumb-item active"><a
                                                            href="<?php echo e(route('website.all-advertisements',$advertisement->subCategory->slug)); ?>?type=View"><?php echo e($advertisement->subCategory->name); ?></a>
                                                    </li>
                                                </ol>
                                                <h5 class="product-title"><a
                                                        href="<?php echo e(route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])); ?>?type=View"><?php echo e($advertisement->title); ?></a>
                                                </h5>
                                                <div class="product-meta"><span><i
                                                            class="fas fa-map-marker-alt"></i>
                                                                               <?php echo e($advertisement->city?$advertisement->city->name:'-'); ?>,<?php echo e($advertisement->city&&$advertisement->city->country?$advertisement->city->country->name:'-'); ?></span><span><i class="fas fa-clock"></i><?php echo e(\Carbon\Carbon::createFromTimeStamp(strtotime($advertisement->created_at))->diffForHumans()); ?></span>
                                                </div>
                                                <div class="product-info">
                                                    <h5 class="product-price"><?php echo e($advertisement->price); ?> <?php echo e($advertisement->city->country->currency); ?>

                                                        <span></span></h5>
                                                    <div class="product-btn"><a
                                                            href="tel:<?php echo e($advertisement->shop->phone); ?>" title="call"
                                                            class="fas fa-phone-alt"></a>
                                                        
                                                        
                                                        <button type="button" title="whatsapp"
                                                                class="fab fa-whatsapp no-top" onclick='window.open("https://api.whatsapp.com/send?phone=<?php echo e($advertisement->phone!=null??$advertisement->shop->phone); ?>")'></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="center-50"><a
                                        href="<?php echo e(route('website.all-advertisements',$category->slug)); ?>?type=View"
                                        class="btn btn-inline"><i
                                            class="fas fa-eye"></i><span> <?php echo e(__('website.view-all-ads')); ?> </span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            <?php endif; ?>

        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    
    
    
    
    
    
    
    

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

    
    
    
    
    
    
    
    
    

    <section class="section city-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2 class="direction"><?php echo e(__('website.top-stores-by')); ?> &nbsp; <span><?php echo e(__('website.for-cities')); ?></span></h2>
                        <p>
                            <?php echo e(__('website.top-stores-by-cities-desc')); ?>

                        </p>
                    </div>
                </div>
            </div>
            <?php if(count($cities)>0): ?>
                <div class="row">
                    <?php $__currentLoopData = $cities->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="col-sm-6 col-md-6 col-lg-<?php echo e($colIndex); ?>">
                            <a href="<?php echo e(route('website.all-shops',$city->slug)); ?>" class="city-card"
                               style="background: url(<?php echo e($city->image()); ?>) no-repeat center; background-size: cover">
                                <div class="city-content">
                                    <h4><?php echo e($city->name); ?></h4>
                                    <p>(<?php echo e($city->shops_count); ?>) <?php echo e(__('website.shops')); ?></p>
                                </div>
                            </a>
                        </div>

                        <?php if($colIndex==3 && $reverse==0): ?>
                            <?php $colIndex++ ?>


                        <?php elseif($colIndex==4 && $reverse==0): ?>
                            <?php $colIndex++ ?>

                        <?php elseif($colIndex==5 && $reverse==0): ?>
                            <?php $colIndex=5 ?>
                            <?php $reverse=1 ?>

                        <?php elseif($colIndex==5 && $reverse==1): ?>
                            <?php $colIndex-- ?>

                        <?php elseif($colIndex==4 && $reverse==1): ?>
                            <?php $colIndex-- ?>

                        <?php elseif($colIndex==3 && $reverse==1): ?>
                            <?php $colIndex=3 ?>
                            <?php $reverse=0 ?>
                        <?php endif; ?>



                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-20"><a href="<?php echo e(route('website.all-cities')); ?>" class="btn btn-inline"><i
                                class="fas fa-eye"></i><span><?php echo e(__('website.view-all-cities')); ?></span></a></div>
                </div>
            </div>
        </div>
    </section>

    <section class="intro-part">

    </section>
    <section class="price-part mb-10">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2><span
                                class="secondary-color bolder"> <?php echo e(__('website.moon')); ?> </span> &nbsp; <?php echo e(__('website.packages-title')); ?>

                        </h2>
                        <p>
                            <?php echo e(__('website.packages-title-desc')); ?>



                        </p>
                    </div>
                </div>
            </div>
            <div class="row mb-10">
                <?php if(count($packages)>0): ?>
                    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-lg-4">
                            <div class="price-card">
                                <div class="price-head"><i class="flaticon-bicycle"></i>
                                    <h3><?php echo e($package->price); ?> <?php echo e($package->country->currency); ?></h3>
                                    <h4> <?php echo e($package->period); ?> <?php echo e(__('website.months')); ?></h4>
                                </div>
                                <ul class="price-list">
                                    <li><i class="fas fa-plus"></i>
                                        <p><?php echo e($package->title); ?></p>
                                    </li>
                                    <li><i class="fas fa-times"></i>
                                        <p><?php echo e(__('website.regular-ads')); ?> <?php echo e($package->advertisements_count); ?></p>
                                    </li>
                                    <li><i class="fas fa-times"></i>
                                        <p><?php echo e(__('website.premium-ads')); ?> <?php echo e($package->premium_advertisements_count); ?></p>
                                    </li>
                                    <li><i class="fas fa-times"></i>
                                        <p><?php echo e(__('website.for')); ?> <?php echo e($package->period); ?> <?php echo e(__('website.months')); ?></p>
                                    </li>
                                </ul>
                                <div class="price-btn"><a target="_blank" href="<?php echo e(route('store.register')); ?>"
                                                          class="btn btn-inline"><i
                                            class="fas fa-sign-in-alt"></i><span><?php echo e(__('website.register-now')); ?></span></a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-20"><a href="<?php echo e(route('website.packages')); ?>" class="btn btn-inline"><i
                                class="fas fa-eye"></i><span><?php echo e(__('website.view-all-prices')); ?></span></a></div>
                </div>
            </div>
        </div>
    </section>
    <?php if(count($blogs)>0): ?>
        <section class="blog-part">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2 class="direction"> <?php echo e(__('website.read-our')); ?>

                                &nbsp; <span> <?php echo e(__('website.recent-articles')); ?> </span>
                            </h2>
                            <p>
                                <?php echo e(__('website.recent-articles-text')); ?>

                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="blog-slider slider-arrow">
                            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="blog-card">
                                    <div class="blog-img"><img src="<?php echo e($blog->image()); ?>" alt="<?php echo e($blog->title); ?>" width="338px">
                                        <div class="blog-overlay">

                                        </div>
                                    </div>
                                    <div class="blog-content">
                                        <a class="blog-avatar">
                                            <img src="<?php echo e($blog->author->image ?? defaultMoonImage()); ?>" alt="<?php echo e($blog->author->name); ?>">
                                        </a>
                                        <ul class="home-blog">
                                            <li><i class="fas fa-user"></i>
                                                <p><a><?php echo e($blog->author->name); ?></a></p>
                                            </li>
                                            <li><i class="fas fa-clock"></i>
                                                <p><?php echo e($blog->created_at); ?></p>
                                            </li>
                                        </ul>
                                        <div class="blog-text">
                                            <h4>
                                                <a href="<?php echo e(route('website.blog-details',['id'=>$blog->id,'slug'=>$blog->slug])); ?>"><?php echo e($blog->title); ?></a>
                                            </h4>
                                            <p><?php echo e(substr(strip_tags($blog->description),1,50)); ?>....</p>
                                        </div>
                                        <a href="<?php echo e(route('website.blog-details',['id'=>$blog->id,'slug'=>$blog->slug])); ?>"
                                           class="blog-read"><span><?php echo e(__('website.read-more')); ?></span><i
                                                class="fas fa-long-arrow-alt-right"></i></a>
                                    </div>
                                </div>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="blog-btn"><a href="<?php echo e(route('website.view-all-blogs')); ?>" class="btn btn-inline"><i
                                    class="fas fa-eye"></i><span><?php echo e(__('website.view-all-blogs')); ?></span></a></div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('extra-js-files'); ?>

    <script src="<?php echo e(asset('website/js/custom/zuck.min.js')); ?>"></script>
    <script src="<?php echo e(asset('website/js/custom/script-story.js')); ?>"></script>
    <script>
        var currentSkin = getCurrentSkin();
        var stories = new Zuck('stories', {
            backNative: true,
            previousTap: true,
            skin: currentSkin['name'],
            autoFullScreen: currentSkin['params']['autoFullScreen'],
            avatars: currentSkin['params']['avatars'],
            paginationArrows: currentSkin['params']['paginationArrows'],
            list: currentSkin['params']['list'],
            cubeEffect: currentSkin['params']['cubeEffect'],
            localStorage: false,
            stories: [
                <?php if(count($shops)>0): ?>
                <?php $__currentLoopData = $shops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                Zuck.buildTimelineItem(
                    "<?php echo e($shop->image()); ?>",
                    "<?php echo e($shop->image()); ?>",

                    "<?php echo e($shop->name); ?>",
                    "<?php echo e($shop->image()); ?>",

                    timestamp(),
                    [
                            <?php $__currentLoopData = $shop->stories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $story): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        ["<?php echo e($shop->name); ?>", "photo", 3, "<?php echo e($story->file()); ?>", " <?php echo e($story->file()); ?>", 'Write A Comment', false, false, timestamp()],
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                ),
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                // Zuck.buildTimelineItem(
                //     "gorillaz",
                //     "images/story/client-2.jpg",
                //     "Burger King 2",
                //     "",
                //     timestamp(),
                //     [
                //         ["gorillaz-1", "video", 0, "images/video.mp4", "images/1.jpg", 'message.html', ' Write a comment ' , false, false, timestamp()],
                //         ["gorillaz-2", "photo", 3, "images/1.jpg", "images/1.jpg",  'message.html', ' Write a comment ', false, false, timestamp()],
                //         ["gorillaz-2", "photo", 3, "images/1.jpg", "images/1.jpg",  'message.html', ' Share2 ', ' like ', false, false, timestamp()],
                //
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "ladygaga",
                //     "images/story/client-3.jpg",
                //     "Bufflo",
                //     "",
                //     timestamp(),
                //     [
                //         ["ladygaga-1", "photo", 5, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()],
                //         ["ladygaga-2", "photo", 3, "images/1.jpg", "images/1.jpg", 'http://ladygaga.com', false, false, timestamp()],
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "starboy",
                //     "images/story/client-3.jpg",
                //     "KFC",
                //     "",
                //     timestamp(),
                //     [
                //         ["starboy-1", "photo", 5, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "riversquomo",
                //     "images/story/client-4.jpg",
                //     "Hadrmot",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 10, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "test2",
                //     "images/story/client-5.jpg",
                //     "shawermty",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 11, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "test",
                //     "images/story/client-6.jpg",
                //     "king BG",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 12, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "test3",
                //     "images/story/client-7.jpg",
                //     "Shrimp Zone",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 13, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test4",
                //     "images/story/client-8.jpg",
                //     "Premos Pizza",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 14, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test5",
                //     "images/story/client-9.jpg",
                //     "El Monofy",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 15, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test6",
                //     "images/story/client-10.jpg",
                //     "Falah Foods",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 16, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test7",
                //     "images/story/client-11.jpg",
                //     "Big Tasty",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 17, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test8",
                //     "images/story/client-6.jpg",
                //     "Shrimp",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 18, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                //
            ]
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('Website.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mtest/public_html/_wildcard_/resources/views/Website/pages/index.blade.php ENDPATH**/ ?>