<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('country_id')->nullable()->constrained()->nullOnDelete();
            $table->boolean('active')->default(\App\Helpers\Constant::PACKAGE_STATUS['Active']);
            $table->tinyInteger('period')->default(0);
            $table->integer('advertisements_count')->default(0);
            $table->boolean('has_premium_ads')->default(\App\Helpers\Constant::PACKAGE_HAS_PREMIUM_ADS['False']);
            $table->boolean('all_categories')->default(0);
            $table->tinyInteger('categories_number')->nullable();
            $table->float('price', 13, 2)->default(0);
            $table->timestamps();
        });

        Schema::create('package_translations', function(Blueprint $table) {
            $table->id();
            $table->foreignId('package_id')->nullable()->constrained()->nullOnDelete();
            $table->string('locale', 2)->index();
            $table->string('title');

            $table->unique(['package_id','locale']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('packages');
    }
};
