<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('properties', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('type')->nullable(); //text,switch,radio
            $table->foreignId('parent_id')->nullable()->references('id')
                ->on('properties')->nullOnDelete();
            $table->boolean('is_category_type')->default(false);
            $table->boolean('is_range')->default(false);
            $table->timestamps();
        });

        Schema::create('property_translations', function(Blueprint $table) {
            $table->id();
            $table->foreignId('property_id')->nullable()->constrained()->nullOnDelete();
            $table->string('locale', 2)->index();
            $table->string('name');
            $table->string('slug');

            $table->unique(['property_id','locale']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('properties');
    }
};
