<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->boolean('seen')->default(0);
            $table->tinyInteger('notify_type'); //\App\Helpers\Constant::NOTIFICATION_TYPE
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('action_by_id')->nullable()->references('id')
                ->on('users')->nullOnDelete();
            $table->boolean('all_users')->default(0);
            $table->char('country_code')->nullable();
            $table->text('text');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
};
